<?php

namespace Ignite\Vendor\Helix\Laravel\Listeners;

use Ignite\Core\Contracts\Entities\User;
use Ignite\Vendor\Helix\Laravel\Contracts\ProvidesHelixPayload;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\RetrievesUserIdAttribute;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\RetrievesUserModel;
use Ignite\Vendor\Helix\Laravel\Sso\Session;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;

class SyncOnRegister
{
    use RetrievesUserIdAttribute;
    use RetrievesUserModel;

    /**
     * @var Session
     */
    private $session;

    /**
     * @var Request
     */
    private $request;

    /**
     * Create the event listener.
     *
     * @param Session $session
     * @param Request $request
     */
    public function __construct(Session $session, Request $request)
    {
        $this->session = $session;
        $this->request = $request;
    }

    /**
     * Handle the event.
     *
     * @param  Registered  $event
     *
     * @return void
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function handle(Registered $event)
    {
        if (! config('helix.enabled')) {
            return;
        }

        // the $event->user from Registered may not necessarily be an
        // instance of ProvidesHelixPayload

        $this->session->handle(
            $this->request,
            $this->getUser($event->user)
        );
    }

    /**
     * Convert the user model to ProvidesHelixPayload instance.
     */
    protected function getUser($user)
    {
        if ($user instanceof User
            && !($user instanceof ProvidesHelixPayload)
        ) {
            $user = $this->getUserModel()->query()
                ->where($this->getUserIdAttribute(), $user->getKey())
                ->firstOrFail();
        }

        return $user;
    }
}
