<?php

namespace Ignite\Vendor\Helix\Laravel\Listeners\Concerns;

use Ignite\Vendor\Helix\Laravel\Exceptions\HelixUserIdAttributeNotConfigured;

trait RetrievesHelixUserIdAttribute
{
    /**
     * Get the Helix User Id from config.
     *
     * @return string
     * @throws HelixUserIdAttributeNotConfigured
     */
    public function getHelixUserIdAttribute()
    {
        if (empty($helixId = config('helix.user.attributes.helix_user_id'))) {
            throw new HelixUserIdAttributeNotConfigured();
        }

        return $helixId;
    }
}
