<?php

namespace Ignite\Vendor\Helix\Laravel\Listeners\Concerns;

use Ignite\Vendor\Helix\Laravel\Exceptions\SsoRequestFailed;
use Ignite\Vendor\Helix\Laravel\Response;
use Ignite\Vendor\Helix\Laravel\Sso\Payload;

trait GuardAgainstFailedSsoRequest
{
    /**
     * Guard against an invalid response from the SSO authentication request.
     *
     * @param Payload $payload
     * @param mixed $response
     *
     * @throws SsoRequestFailed
     */
    public function guardAgainstFailedSsoRequest($payload, $response)
    {
        if (! $response || ($response instanceof Response && $response->failed())) {
            // add extra details in the message so it can show in Flare
            // and not have to check the log files manually.
            $message = json_encode([
                'Error' => ($response instanceof Response ? $response->message() : 'Response failed.'),
                'Payload' => $payload,
                'Response' => ($response instanceof Response ? $response->toArray() : $response),
            ]);

            throw new SsoRequestFailed($payload, $response, $message);
        }
    }
}
