<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns;

use Ignite\Vendor\Helix\Laravel\Exceptions\UserModelNotConfigured;

trait RetrievesUserModel
{
    /**
     * Get the user model.
     *
     * @return \Illuminate\Database\Eloquent\Model
     * @throws UserModelNotConfigured
     */
    public function getUserModel()
    {
        $modelClass = config('helix.user.model');

        if (empty($modelClass) || ! class_exists($modelClass)) {
            throw new UserModelNotConfigured();
        }

        return new $modelClass;
    }
}
