<?php

namespace Ignite\Vendor\Helix\Laravel\Events;

use Ignite\Vendor\Helix\Laravel\Resources\Webhook;
use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;

class WebhookResourceCreated
{
    use Dispatchable, SerializesModels;

    /**
     * @var Webhook
     */
    protected $webhook;

    /**
     * Create a new event instance.
     *
     * @param Webhook $webhook
     */
    public function __construct(Webhook $webhook)
    {
        $this->webhook = $webhook;
    }

    /**
     * The order resource model.
     *
     * @return Webhook
     */
    public function getWebhook()
    {
        return $this->webhook;
    }
}
