<?php

namespace Ignite\Vendor\Helix\Laravel\Tests\Unit\Carriers;

use Ignite\Vendor\Helix\Laravel\Carriers\Carrier;
use Ignite\Vendor\Helix\Laravel\Carriers\CarrierCollectionInterface;
use Ignite\Vendor\Helix\Laravel\Carriers\ArrayCollection;
use Ignite\Vendor\Helix\Laravel\Carriers\CarrierInterface;
use Ignite\Vendor\Helix\Laravel\Tests\TestCase;

class ArrayCollectionTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_resolve_the_array_collection_from_the_container()
    {
        $collection = app(CarrierCollectionInterface::class);
        $this->assertInstanceOf(ArrayCollection::class, $collection);
        $this->assertInstanceOf(CarrierInterface::class, $collection->find('US-USPS'));
        $this->assertEquals('USPS', $collection->find('US-USPS')->getName());
    }

    /**
     * @test
     */
    public function it_can_read_the_carriers_from_config_and_hydrate_the_data_into_carrier_classes()
    {
        $collection = new ArrayCollection([
            'US-USP' => [
                'name' => 'USPS',
                'code' => 'USP',
                'url' => 'https://tools.usps.com/go/TrackConfirmAction_input',
                'query' => '?qtc_tLabels1=',
                'number' => '12345'
            ]
        ]);

        $carrier = $collection->find('US-USP');

        $this->assertInstanceOf(Carrier::class, $carrier);
        $this->assertEquals('USPS', $carrier->getName());
        $this->assertEquals('USP', $carrier->getCode());
        $this->assertEquals('12345', $carrier->getTrackingNumber());
        $this->assertEquals('https://tools.usps.com/go/TrackConfirmAction_input', $carrier->getUrl());
        $this->assertEquals('?qtc_tLabels1=', $carrier->getQuery());
        $this->assertEquals(
            'https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=12345',
            $carrier->getFullUrl()
        );
    }
}
