<?php

namespace Ignite\Vendor\Helix\Laravel\Sso;

use Ignite\Vendor\Helix\AdapterInterface;
use Ignite\Vendor\Helix\Laravel\Contracts\SsoClientInterface;
use Ignite\Vendor\Helix\Laravel\Contracts\DecoratableSsoClientInterface;
use Ignite\Vendor\Helix\Laravel\Exceptions\PayloadValidationFailed;
use Psr\Http\Message\ResponseInterface;

class Client implements SsoClientInterface, DecoratableSsoClientInterface
{
    const SSO_INVALID_DATA = 'invalid-data';
    const SSO_INVALID_RESPONSE = 'invalid-response';
    const SSO_INVALID_LOGIN_URL = 'invalid-login-url';
    const SSO_UNKNOWN_ERROR = 'error';

    /**
     * @var AdapterInterface
     */
    private $adapter;

    /**
     * Client constructor.
     *
     * @param AdapterInterface $adapter
     */
    public function __construct(AdapterInterface $adapter)
    {
        $this->adapter = $adapter;
    }

    /**
     * Execute the sign up request.
     *
     * @param Payload $payload
     *
     * @return ResponseInterface
     * @throws PayloadValidationFailed
     */
    public function signUp(Payload $payload)
    {
        return $this->adapter->request('POST', 'signup', [
            'json' => $payload->forSignUp(),
            'auth' => null
        ]);
    }

    /**
     * Execute the sign up request.
     *
     * @param Payload $payload
     *
     * @return ResponseInterface
     * @throws PayloadValidationFailed
     */
    public function signIn(Payload $payload)
    {
        return $this->adapter->request('POST', 'signup', [
            'json' => $payload->forSignIn(),
            'auth' => null,
        ]);
    }
}
