<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers;

use Exception;
use Ignite\Vendor\Helix\Laravel\Exceptions\InvalidAccessToken;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\CommonResponses;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\GuardAgainstInvalidToken;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\RetrievesPointsAttribute;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\RetrievesUserIdAttribute;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\RetrievesUserModel;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\TranslatesMessages;
use Ignite\Vendor\Helix\Laravel\Services\Token;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class PointsController
{
    use RetrievesUserModel,
        RetrievesUserIdAttribute,
        RetrievesPointsAttribute,
        GuardAgainstInvalidToken,
        CommonResponses,
        TranslatesMessages;

    /**
     * Store the points check request.
     *
     * @param Request $request
     * @param Token $tokenService
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function __invoke(Request $request, Token $tokenService)
    {
        $userId = $request->json()->get('clientUserId');

        try {
            $this->guardAgainstInvalidAccessToken($request, $tokenService);

            $user = $this->getUserModel()->query()
                ->where($this->getUserIdAttribute(), $userId)
                ->firstOrFail();

            return $this->successResponse($request, $this->message('points.success'), [
                'points' => (int) $user->getAttribute($this->getPointsAttribute())
            ]);
        } catch (ModelNotFoundException $exception) {
            logger()->error($exception->getMessage(), compact('exception', 'request'));

            return $this->notFoundResponse($request, $this->message('points.missing', [
                'user' => $userId ?? 'Missing'
            ]));
        } catch (InvalidAccessToken $exception) {
            logger()->error($exception->getMessage(), compact('exception', 'request'));

            return $this->forbiddenResponse($request, $this->message('points.forbidden'));
        } catch (Exception $exception) {
            logger()->error($exception->getMessage(), compact('exception', 'request'));

            return $this->serviceUnavailableResponse($request, $this->message('points.unavailable'));
        }
    }
}
