<?php

namespace Ignite\Vendor\Helix\Laravel\Tests\Unit\Carriers;

use Ignite\Vendor\Helix\Laravel\Carriers\ArrayCollection;
use Ignite\Vendor\Helix\Laravel\Carriers\Factory;
use Ignite\Vendor\Helix\Laravel\Tests\TestCase;

class FactoryTest extends TestCase
{
    /**
     * @test
     */
    public function it_find_the_carrier_data_using_country_and_code()
    {
        $factory = new Factory(new ArrayCollection([
            'US-USP' => [
                'name' => 'USPS',
                'code' => 'USP',
                'url' => 'https://tools.usps.com/go/TrackConfirmAction_input',
                'query' => '?qtc_tLabels1=',
                'number' => '12345'
            ]
        ]));

        $this->assertEquals('USPS', $factory->find('us', 'UsP', 12345)->getName());
    }
}
