<?php

namespace Ignite\Vendor\Helix\Laravel\Tests\Unit\Listeners;

use Ignite\Vendor\Helix\Laravel\Contracts\DecoratableSsoClientInterface;
use Ignite\Vendor\Helix\Laravel\Listeners\SyncOnRegister;
use Ignite\Vendor\Helix\Laravel\Response;
use Ignite\Vendor\Helix\Laravel\Sso\Payload;
use Ignite\Vendor\Helix\Laravel\Sso\Session;
use Ignite\Vendor\Helix\Laravel\Tests\TestCase;
use Illuminate\Auth\Events\Registered;
use Mockery;

class SyncOnRegisterTest extends TestCase
{
    /**
     * @test
     */
    public function it_will_sign_in_and_store_the_login_url_in_the_session()
    {
        $sessionKey = config('helix.sso.session.key');
        $helixIdAttribute = config('helix.user.attributes.helix_user_id');

        $response = $this->getResponseData([
            'helixUserId' => $helixUserId = '690901',
            'URL' => $loginUrl = "http://52.60.111.154/brightspot/login/D5F9350EF38FC919E684023E68670584F951E3216391E53F28CDB64274D1C1EC"
        ]);

        $payload = new Payload($this->getPayloadData());

        request()->setLaravelSession(session());

        $client = Mockery::mock(DecoratableSsoClientInterface::class);
        $client->shouldReceive('signUp')->once()->andReturn(new Response($response));

        $session = new Session($client);

        $user = $this->getMockUser($payload);
        $user->shouldReceive('getAttribute')->once()->with($helixIdAttribute)->andReturn(null);
        $user->shouldReceive('update')->once();

        $listener = new SyncOnRegister($session, request());
        $listener->handle(new Registered($user));

        $this->assertEquals($loginUrl, session($sessionKey));
    }
}
