<?php

namespace Ignite\Vendor\Helix\Laravel\Tests\Stubs;

use Ignite\Vendor\Helix\Laravel\Contracts\ProvidesHelixPayload;
use Ignite\Vendor\Helix\Laravel\Resources\Concerns\Payloadable;
use Illuminate\Database\Eloquent\Model;

class User extends Model implements ProvidesHelixPayload
{
    use Payloadable;

    protected $guarded = [];

    /**
     * Provide the helix data necessary to authenticate a user.
     *
     * @return array
     */
    public function toPayload()
    {
        return [
            'helixUserId' => $this->getAttribute('helix_user_id') ?? '10101234',
            'catalogId' => $this->getAttribute('catalog_id') ?? 'A14E715F-CAF0-4749-B569-58059C9DD490',
            'memberGroupId' => null,
            'accessToken' => $this->getAttribute('access_token') ?? 'E7DFA4373E531A7AA23B1955B94E6526F4B33587FFE12A758DCB35E48736251B',
            'clientUserId' => $this->getAttribute(config('helix.user.attributes.id')) ?? 1,
            'firstName' => $this->getAttribute('first') ?? 'John',
            'lastName' => $this->getAttribute('last') ?? 'Smith',
            'primaryLanguage' => $this->getAttribute('locale') ?? 'en',
            'points' => $this->getAttribute('points') ?? 100,
            'phoneNumber1' => $this->getAttribute('phone') ?? '555 123 4567',
            'emailAddress' => $this->getAttribute('email') ?? 'it@brightspot.email',
            'shipAddress1' => $this->getAttribute('address_1') ?? '102 Decker Ct',
            'shipAddress2' => $this->getAttribute('address_2') ?? 'Suite 150',
            'shipCity' => $this->getAttribute('city') ?? 'Irving',
            'shipState' => $this->getAttribute('state') ?? 'TX',
            'shipPostalCode' => $this->getAttribute('postcode') ?? '75065',
            'shipCountry' => $this->getAttribute('country') ?? 'US',
        ];
    }
}
