<?php

namespace Ignite\Vendor\Helix\Laravel\Listeners;

use Ignite\Vendor\Helix\Laravel\Sso\Session;
use Illuminate\Auth\Events\Login;
use Illuminate\Http\Request;

class SyncOnLogin
{
    /**
     * @var Session
     */
    private $session;

    /**
     * @var Request
     */
    private $request;

    /**
     * Create the event listener.
     *
     * @param Session $session
     * @param Request $request
     */
    public function __construct(Session $session, Request $request)
    {
        $this->session = $session;
        $this->request = $request;
    }

    /**
     * Handle the event.
     *
     * @param Login $event
     *
     * @return void
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function handle(Login $event)
    {
        if (! config('helix.enabled')) {
            return;
        }

        /* -------------------------------------------------- //
         If you get an error like:
            Argument 2 passed to Ignite\Vendor\Helix\Laravel\Sso\Session::handle() must be an instance
            of Ignite\Vendor\Helix\Laravel\Contracts\ProvidesHelixPayload, instance of Ignite\Core\Entities\User given,
            called in helix-api-laravel/src/Listeners/SyncOnLogin.php

         Then you may need to update config/auth.php and change this:

            'providers' => [
                'users' => [
                    'driver'   => 'ignite',
                    'model'    => Ignite\Core\Entities\User::class,
                ],
            ],

         to:

            'providers' => [
                'users' => [
                    'driver'   => 'ignite',
                    // use this class or a subclass
                    'model'    => Ignite\HelixCatalog\Entities\User::class,
                ],
            ],
         * -------------------------------------------------- */
        $this->session->handle($this->request, $event->user);
    }
}
