<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns;

use Ignite\Vendor\Helix\Laravel\Exceptions\UserIdAttributeNotConfigured;

trait RetrievesUserIdAttribute
{
    /**
     * The points attribute on the use model.
     *
     * @return string
     * @throws UserIdAttributeNotConfigured
     */
    public function getUserIdAttribute()
    {
        if (empty($attribute = config('helix.user.attributes.id'))) {
            throw new UserIdAttributeNotConfigured();
        }

        return $attribute;
    }
}
