<?php

namespace Ignite\Vendor\Helix\Laravel\Commands;

use Ignite\Vendor\Helix\Laravel\Resources\Order;
use Ignite\Vendor\Helix\Laravel\Resources\Webhook;
use Illuminate\Console\Command;
use Illuminate\Support\Collection;
use Illuminate\Support\Str;

class PurgeProcessedResources extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'helix:resources:purge {resource}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Purge all processed resources.';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $resource = $this->argument('resource');

        if (! $this->resources()->has($resource)) {
            $this->warn("Unknown resource '{$resource}'");
            return 1;
        }

        $resourceClass = $this->resources()->get($resource);
        $resourceQuery = $resourceClass::query()->withProcessed();
        $count = $resourceQuery->count();
        $subject = Str::plural(Str::singular($resource), $count);

        if ($count > 0) {
            $resourceQuery->withProcessed()->delete();
            $this->info("{$count} {$subject} purged successfully.");
        } else {
            $this->comment("No processed {$subject} found.");
        }
    }

    /**
     * The collection of available resources.
     *
     * @return Collection
     */
    protected function resources()
    {
        return new Collection([
            'orders' => Order::class,
            'webhooks' => Webhook::class,
        ]);
    }
}
