<?php

namespace Ignite\Vendor\Helix\Laravel\Carriers;

use Ignite\Vendor\Helix\Laravel\Carriers\Carrier;
use Ignite\Vendor\Helix\Laravel\Carriers\CarrierCollectionInterface;
use Ignite\Vendor\Helix\Laravel\Carriers\CarrierInterface;
use Illuminate\Support\Collection;

class ArrayCollection extends Collection implements CarrierCollectionInterface
{
    public function __construct($items = [])
    {
        $items = array_map(function ($carrier) {
            return Carrier::createFromArray($carrier);
        }, $items);

        parent::__construct($items);
    }

    /**
     * @inheritDoc
     */
    public function find($code)
    {
        return $this->get($code);
    }
}
