<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns;

use Ignite\Vendor\Helix\Laravel\Exceptions\InvalidAccessToken;
use Ignite\Vendor\Helix\Laravel\Services\Token;
use Illuminate\Http\Request;

trait GuardAgainstInvalidToken
{
    /**
     * Guard against an invalid access token by throwing an exception.
     *
     * @param Request $request
     * @param Token $tokenService
     *
     * @throws InvalidAccessToken
     */
    private function guardAgainstInvalidAccessToken(Request $request, Token $tokenService)
    {
        $accessToken = $request->get('accessToken', $request->json()->get('accessToken', null));

        if (empty($accessToken)) {
            throw new InvalidAccessToken($accessToken);
        }

        $token = $tokenService->encrypt(
            $catalog = config('helix.token.catalog'),
            $key = optional($request->user())->getKey() ?? $request->json()->get('clientUserId', 0)
        );

        if ($accessToken !== $token) {
            throw new InvalidAccessToken($accessToken);
        }
    }
}
