<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns;

use Ignite\Vendor\Helix\Laravel\Http\Responses\ApiResponse;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

trait CommonResponses
{
    /**
     * Return a 200 OK Response.
     *
     * @param Request $request
     * @param string $message
     * @param array $overrides
     *
     * @return JsonResponse
     */
    protected function successResponse($request, $message = 'Processed', array $overrides = [])
    {
        return ApiResponse::make()
            ->data($overrides)
            ->success()
            ->message($message)
            ->toResponse($request);
    }
    
    /**
     * Return a 403 Forbidden Response.
     *
     * @param Request $request
     * @param string $message
     *
     * @return JsonResponse
     */
    protected function forbiddenResponse(Request $request, $message = 'Forbidden')
    {
        return ApiResponse::make()
            ->error(JsonResponse::HTTP_FORBIDDEN)
            ->message($message)
            ->toResponse($request);
    }

    /**
     * Return a 404 Not Found Response.
     *
     * @param Request $request
     * @param string $message
     *
     * @return JsonResponse
     */
    protected function notFoundResponse(Request $request, $message = 'Not Found')
    {
        return ApiResponse::make()
            ->error(JsonResponse::HTTP_NOT_FOUND)
            ->message($message)
            ->toResponse($request);
    }

    /**
     * Return a 503 Service Unavailable Response.
     *
     * @param Request $request
     * @param string $message
     *
     * @return JsonResponse
     */
    protected function serviceUnavailableResponse(Request $request, $message = 'Service Unavailable')
    {
        return ApiResponse::make()
            ->header('Retry-After', $threeDays = (60 * 60 * 24) * 3)
            ->error(JsonResponse::HTTP_SERVICE_UNAVAILABLE)
            ->message($message)
            ->toResponse($request);
    }
}
