<?php

namespace Ignite\Vendor\Helix\Laravel\Exceptions;

use Throwable;

class SsoBadLoginUrl extends \Exception
{
    /**
     * @var null
     */
    private $response;

    /**
     * SsoBasLoginUrl constructor.
     *
     * @param mixed $response
     * @param string $message
     * @param int $code
     * @param Throwable|null $previous
     */
    public function __construct($response = null, $message = "", $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->response = $response;
    }

    /**
     * The response from the SSO request.
     *
     * @return mixed
     */
    public function getResponse()
    {
        return $this->response;
    }
}
