<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/iframe-resizer/4.1.1/iframeResizer.min.js" integrity="sha256-cEc8isF4TnMrb5OarPG3xyR5aOlECPt9Dbup+rFaEcw=" crossorigin="anonymous"></script>
<script>
  window.jQuery.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });
  window.Helix = window.Helix || {};
  window.Helix.initFrame = function () {
    iFrameResize({
      targetOrigin: 'https://biapi.helixgs.com/',
      log: false,
      autoResize: true,
      scrolling: false,
      heightCalculationMethod: 'max',
      widthCalculationMethod: 'min',
      warningTimeout: 15000,
      checkOrigin: true,
      resizeFrom: 'child',
      sizeHeight: true,
      sizeWidth: true,
      tolerance: 10,
      bodyPadding: '0 0 50px',
      onMessage: function (payload) {
        if (payload.message.type === 'timeout') {
          window.Helix.regenerate({
            accessToken: payload.message.accessToken
          });
        }
      }
    }, '#helix');
  };
  window.Helix.regenerate = function (data, callback) {
    window.jQuery.ajax({
      url: "/api/helix/session",
      type: 'POST',
      data: data,
      dataType: 'json',
      headers: {
        contentType: 'application/json'
      },
      success: callback || function () {
        window.location.reload();
      }
    });
  };
  setTimeout(function () {
    window.Helix.initFrame();
  }, 500);
</script>
