<?php

namespace Ignite\Vendor\Helix\Laravel\Listeners;

use Ignite\Vendor\Helix\Laravel\Sso\Session;
use Illuminate\Auth\Events\Login;
use Illuminate\Http\Request;

class SyncOnLogin
{
    /**
     * @var Session
     */
    private $session;

    /**
     * @var Request
     */
    private $request;

    /**
     * Create the event listener.
     *
     * @param Session $session
     * @param Request $request
     */
    public function __construct(Session $session, Request $request)
    {
        $this->session = $session;
        $this->request = $request;
    }

    /**
     * Handle the event.
     *
     * @param Login $event
     *
     * @return void
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function handle(Login $event)
    {
        if (! config('helix.enabled')) {
            return;
        }

        $this->session->handle($this->request, $event->user);
    }
}
