<?php

namespace Ignite\Vendor\Helix\Laravel\Listeners\Concerns;

use Ignite\Vendor\Helix\Laravel\Exceptions\SsoRequestFailed;
use Ignite\Vendor\Helix\Laravel\Response;
use Ignite\Vendor\Helix\Laravel\Sso\Payload;

trait GuardAgainstFailedSsoRequest
{
    /**
     * Guard against an invalid response from the SSO authentication request.
     *
     * @param Payload $payload
     * @param mixed $response
     *
     * @throws SsoRequestFailed
     */
    public function guardAgainstFailedSsoRequest($payload, $response)
    {
        if (! $response || ($response instanceof Response && $response->failed())) {
            throw new SsoRequestFailed($payload, $response, 'Response failed.');
        }
    }
}
