<?php

namespace Ignite\Vendor\Helix\Laravel\Carriers;

interface CarrierInterface
{
    /**
     * The carrier name.
     *
     * @param string $name
     *
     * @return string
     */
    public function setName($name);

    /**
     * The carrier name.
     *
     * @return string
     */
    public function getName();

    /**
     * The carrier code.
     *
     * @param string $code
     *
     * @return string
     */
    public function setCode($code);

    /**
     * The carrier code.
     *
     * @return string
     */
    public function getCode();

    /**
     * Determine whether the carrier has a URL.
     *
     * @return bool
     */
    public function hasUrl();

    /**
     * The carrier tracking url.
     *
     * @param string $url
     *
     * @return string
     */
    public function setUrl($url);

    /**
     * The carrier tracking URL.
     *
     * @return string
     */
    public function getUrl();

    /**
     * The carrier tracking query.
     *
     * @param string $query
     *
     * @return string
     */
    public function setQuery($query);

    /**
     * The carrier tracking query.
     *
     * @return string
     */
    public function getQuery();

    /**
     * The full url includes the tracking url, the query string and the tracking number.
     *
     * @return string
     */
    public function getFullUrl();

    /**
     * The carrier tracking number.
     *
     * @param string $number
     *
     * @return string
     */
    public function setTrackingNumber($number);

    /**
     * The carrier tracking number.
     *
     * @return string
     */
    public function getTrackingNumber();
}
