<?php

namespace Ignite\Vendor\Helix\Laravel\Carriers;

class Carrier implements CarrierInterface
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $code;

    /**
     * @var string
     */
    private $url;

    /**
     * @var string|null
     */
    private $query;

    /**
     * @var string|null
     */
    private $number;

    /**
     * Create a carrier from a know multi-dimensional array.
     *
     * @param array $carrier
     *
     * @return static
     */
    public static function createFromArray($carrier)
    {
        return new static(
            $carrier['name'],
            $carrier['code'],
            $carrier['url'] ?? null,
            $carrier['query'] ?? null,
            $carrier['number'] ?? null
        );
    }

    /**
     * Carrier constructor.
     *
     * @param string $name
     * @param string $code
     * @param string $url
     * @param string|null $query
     * @param string|null $number
     */
    public function __construct($name, $code, $url, $query = null, $number = null)
    {
        $this->name = $name;
        $this->code = $code;
        $this->url = $url;
        $this->query = $query;
        $this->number = $number;
    }

    /**
     * @inheritDoc
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @inheritDoc
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @inheritDoc
     */
    public function hasUrl()
    {
        return ! empty($this->url);
    }

    /**
     * @inheritDoc
     */
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @inheritDoc
     */
    public function setQuery($query)
    {
        $this->query = $query;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * @inheritDoc
     */
    public function getFullUrl()
    {
        return $this->url . $this->query . $this->number;
    }

    /**
     * @inheritDoc
     */
    public function setTrackingNumber($number)
    {
        $this->number = $number;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getTrackingNumber()
    {
        return $this->number;
    }
}
