<?php

namespace Ignite\Vendor\Helix\Laravel\Tests\Unit\Carriers;

use Ignite\Vendor\Helix\Laravel\Carriers\ArrayCollection;
use Ignite\Vendor\Helix\Laravel\Carriers\Carrier;
use Ignite\Vendor\Helix\Laravel\Carriers\Factory;
use Ignite\Vendor\Helix\Laravel\Tests\TestCase;

class CarrierTest extends TestCase
{
    /**
     * @var Carrier
     */
    private $carrier;

    public function setUp(): void
    {
        parent::setUp();

        $this->carrier = new Carrier('Foodex', 'FOO', 'https://foodex.com/parceltracker', '?number=', 12345);
    }

    /**
     * @test
     */
    public function it_can_set_and_get_the_carrier_name()
    {
        $this->carrier->setName('Bar');
        $this->assertEquals('Bar', $this->carrier->getName());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_the_carrier_code()
    {
        $this->carrier->setCode('BAR');
        $this->assertEquals('BAR', $this->carrier->getCode());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_the_carrier_url()
    {
        $this->carrier->setUrl('https://barpost.ca/nonsense');
        $this->assertEquals('https://barpost.ca/nonsense', $this->carrier->getUrl());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_the_carrier_tracking_url_query()
    {
        $this->carrier->setQuery('?blah=fitznerp');
        $this->assertEquals('?blah=fitznerp', $this->carrier->getQuery());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_the_carrier_tracking_number()
    {
        $this->carrier->setTrackingNumber('1234-0012-3456-7890');
        $this->assertEquals('1234-0012-3456-7890', $this->carrier->getTrackingNumber());
    }

    /**
     * @test
     */
    public function it_can_check_if_the_carrier_has_a_url()
    {
        $this->assertTrue($this->carrier->hasUrl());

        $this->carrier->setUrl('');

        $this->assertFalse($this->carrier->hasUrl());

    }

    /**
     * @test
     */
    public function it_can_format_the_full_tracking_url()
    {
        $this->assertEquals('https://foodex.com/parceltracker?number=12345', $this->carrier->getFullUrl());
    }
}
