<?php

namespace Ignite\Vendor\Helix\Laravel\Sso;

use Ignite\Vendor\Helix\Laravel\Exceptions\PayloadValidationFailed;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Fluent;

class Payload extends Fluent
{
    /**
     * @var array
     */
    protected $allowedKeys = [
        'helixUserId',
        'catalogId',
        'accessToken',
        'clientUserId',
        'firstName',
        'lastName',
        'primaryLanguage',
        'points',
        'phoneNumber1',
        'phoneNumber2',
        'emailAddress',
        'shipAddress1',
        'shipAddress2',
        'shipCity',
        'shipState',
        'shipPostalCode',
        'shipCountry',
        'homeAddress1',
        'homeAddress2',
        'homeCity',
        'homeState',
        'homePostalCode',
        'homeCountry',
        'customField1',
        'customField2',
        'customField3',
    ];

    /**
     * Create a new payload instance.
     *
     * @param  array|object  $attributes
     * @return void
     */
    public function __construct($attributes = [])
    {
        parent::__construct(Arr::only($attributes, $this->allowedKeys));
    }

    /**
     * Convert the fluent instance to an array.
     *
     * @return array
     */
    public function toArray()
    {
        return Arr::only($this->attributes, $this->allowedKeys);
    }

    /**
     * The payload for sign up.
     *
     * @return array
     * @throws PayloadValidationFailed
     */
    public function forSignUp()
    {
        return $this->validateKeys(array_filter(Arr::except($this->toArray(), 'helixUserId')));
    }

    /**
     * The payload for sign in.
     *
     * @return array
     * @throws PayloadValidationFailed
     */
    public function forSignIn()
    {
        return $this->validateKeys(array_filter($this->toArray()));
    }

    /**
     * Validate the payload keys.
     *
     * @param array $data
     *
     * @return array
     * @throws PayloadValidationFailed
     */
    protected function validateKeys(array $data)
    {
        $validator = Validator::make($data, [
            'catalogId' => 'required',
            'clientUserId' => 'required',
            'accessToken' => 'required|string',
            'firstName' => 'required|string',
            'lastName' => 'required|string',
            'shipAddress1' => 'required|string',
            'shipCity' => 'required|string',
            'shipState' => 'required|string',
            'shipPostalCode' => 'required|string',
            'shipCountry' => 'required|string',
            'phoneNumber1' => 'required|string',
            'emailAddress' => 'required|email',
        ]);

        if ($validator->fails()) {
            throw new PayloadValidationFailed($validator->errors());
        }

        return $data;
    }
}
