<?php

namespace Ignite\Vendor\Helix\Laravel\Resources;

use Ignite\Vendor\Helix\Laravel\Resources\Concerns\Statusable;
use Illuminate\Database\Eloquent\Model;

/**
 * Webhook
 *
 * @property int $id
 * @property int $user_id
 * @property array $payload
 * @property string $hash
 * @property string $status
 */
class Webhook extends Model
{
    use Statusable;

    const STATUS_PROCESSING = 'processing';
    const STATUS_PROCESSED = 'processed';
    const STATUS_PURGING = 'purging';

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'helix_webhooks';

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'payload' => 'array'
    ];
}
