<?php

namespace Ignite\Vendor\Helix\Laravel\Decorators;

use Ignite\Vendor\Helix\AbstractDecorator;
use Ignite\Vendor\Helix\Laravel\Response;
use Ignite\Vendor\Helix\Laravel\Contracts\DecoratableSsoClientInterface;
use Ignite\Vendor\Helix\Laravel\Sso\Payload;
use Ignite\Vendor\Helix\Transformers\Json as JsonTransformer;
use Psr\Http\Message\ResponseInterface;

/**
 * Json Response Decorator.
 *
 * @method mixed getBrandList()
 * @method mixed getCategoryList($countryCode = 'US', $languageCode = 'eng')
 * @method mixed getSubCategoryList($categoryId, $countryCode = 'US', $languageCode = 'eng')
 * @method mixed getProductList($categoryId, $countryCode = 'US', $languageCode = 'eng')
 * @method mixed getProductDetails($productId, $countryCode = 'US', $languageCode = 'eng')
 * @method mixed getFeaturedProducts($countryCode = 'US', $languageCode = 'eng')
 * @method mixed getOrderDetails($orderId)
 * @method mixed placeOrder(array $billingItems, array $orderItems)
 * @method mixed cancelOrder($orderId)
 * @method mixed signIn(Payload $payload)
 * @method mixed signUp(Payload $payload)
 */
final class Laravel extends AbstractDecorator implements DecoratableSsoClientInterface
{
    /**
     * Decorate the client response.
     *
     * @param  ResponseInterface $response
     * @return array|mixed
     * @throws \Exception
     */
    public function decorate(ResponseInterface $response)
    {
        return new Response((new JsonTransformer)->transform($response));
    }
}
