<?php

namespace Ignite\Vendor\Helix\Laravel\Tests\Unit\Sso;

use Ignite\Vendor\Helix\Laravel\Sso\Payload;
use Ignite\Vendor\Helix\Laravel\Tests\TestCase;

class PayloadTest extends TestCase
{
    /**
     * @test
     */
    public function it_will_not_set_helix_user_id_for_sign_in_method()
    {
        $payload = new Payload($this->getPayloadData([
            'helixUserId' => 6060123
        ]));

        $this->assertArrayHasKey('helixUserId', $payload->forSignIn());
    }

    /**
     * @test
     */
    public function it_will_set_helix_user_id_for_sign_in_method()
    {
        $payload = new Payload($this->getPayloadData([
            'helixUserId' => 6060123
        ]));

        $this->assertArrayNotHasKey('helixUserId', $payload->forSignUp());
    }
}
