<?php

namespace Ignite\Vendor\Helix\Laravel\Carriers;

final class Factory
{
    /**
     * @var CarrierCollectionInterface
     */
    private $carrierCollection;

    /**
     * Factory constructor.
     *
     * @param CarrierCollectionInterface $carrierCollection
     */
    public function __construct(CarrierCollectionInterface $carrierCollection)
    {
        $this->carrierCollection = $carrierCollection;
    }

    /**
     * Find the  carrier by country and code.
     *
     * @param string $country
     * @param string $code
     * @param string $number
     *
     * @return CarrierInterface
     */
    public function find($country, $code, $number)
    {
        $carrier = $this->get($this->code($country, $code));

        return optional($carrier)->setTrackingNumber($number) ?? null;
    }

    /**
     * Get the  carrier by code.
     *
     * @param string $code
     *
     * @return CarrierInterface
     */
    private function get($code)
    {
        return $this->carrierCollection->find($code);
    }

    /**
     * Format the country and code into a ussable key.
     *
     * @param string $country
     * @param string $code
     *
     * @return string
     */
    private function code($country, $code)
    {
        return strtoupper("{$country}-{$code}");
    }
}