<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateHelixOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('helix_orders', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('order_number')->nullable();
            $table->unsignedBigInteger('user_id');
            $table->string('access_token');
            $table->unsignedBigInteger('qty');
            $table->unsignedBigInteger('points');
            $table->string('first');
            $table->string('last');
            $table->string('ship_address_1');
            $table->string('ship_address_2')->nullable();
            $table->string('ship_city');
            $table->string('ship_state');
            $table->string('ship_postcode');
            $table->string('ship_country');
            $table->string('ship_phone');
            $table->text('products')->nullable();
            $table->text('extra')->nullable();
            $table->string('status')->nullable()->default('processing');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('helix_orders');
    }
}
