<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers;

use Ignite\Vendor\Helix\Laravel\Exceptions\InvalidAccessToken;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\CommonResponses;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\GuardAgainstInvalidToken;
use Ignite\Vendor\Helix\Laravel\Services\Token;
use Ignite\Vendor\Helix\Laravel\Sso\Session;
use Illuminate\Http\Request;

class SessionController
{
    use CommonResponses, GuardAgainstInvalidToken;

    /**
     * @var Session
     */
    private $session;

    /**
     * SessionController constructor.
     *
     * @param Session $session
     */
    public function __construct(Session $session)
    {
        $this->session = $session;
    }

    /**
     * Store the points check request.
     *
     * @param Request $request
     * @param Token $tokenService
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function __invoke(Request $request, Token $tokenService)
    {
        try {
            $this->guardAgainstInvalidAccessToken($request, $tokenService);

            $this->session->handle($request, $request->user());

            return $this->successResponse($request);
        } catch (InvalidAccessToken $exception) {
            return $this->forbiddenResponse($request);
        } catch (\Exception $exception) {
            return $this->serviceUnavailableResponse($request);
        }
    }
}
