<?php

namespace Ignite\Vendor\Helix\Laravel\Facades;

use Illuminate\Support\Facades\Facade;

/**
 * Helix Facade.
 *
 * @method mixed getBrandList()
 * @method mixed getCategoryList($countryCode = 'US', $languageCode = 'eng')
 * @method mixed getSubCategoryList($categoryId, $countryCode = 'US', $languageCode = 'eng')
 * @method mixed getProductList($categoryId, $countryCode = 'US', $languageCode = 'eng')
 * @method mixed getProductDetails($productId, $countryCode = 'US', $languageCode = 'eng')
 * @method mixed getFeaturedProducts($countryCode = 'US', $languageCode = 'eng')
 * @method mixed getOrderDetails($orderId)
 * @method mixed placeOrder(array $billingItems, array $orderItems)
 * @method mixed cancelOrder($orderId)
 */
class Helix extends Facade
{
    /**
     * Get the registered name of the component.
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'helix';
    }
}
