<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers;

use Ignite\Vendor\Helix\Laravel\Listeners\Concerns\RetrievesSsoSessionKey;
use Illuminate\Http\RedirectResponse;

class RedirectController
{
    use RetrievesSsoSessionKey;

    /**
     * Store the points check request.
     *
     * @return RedirectResponse
     */
    public function __invoke()
    {
        $url = filter_var(session()->get($this->getSessionKey(), null), FILTER_VALIDATE_URL);

        abort_if(! $url, 500, 'Unable to create a catalog session.');

        return redirect(session());
    }
}
