<?php

namespace Ignite\Vendor\Helix\Laravel\Tests\Unit\Sso;

use Ignite\Vendor\Helix\Laravel\Sso\Payload;
use Ignite\Vendor\Helix\Laravel\Tests\TestCase;

class PayloadTest extends TestCase
{
    /**
     * @test
     */
    public function it_will_not_set_helix_user_id_for_sign_in_method()
    {
        $payload = new Payload($this->getPayloadData());

        $this->assertArrayHasKey('helixUserId', $payload->forSignIn());
    }

    /**
     * @test
     */
    public function it_will_set_helix_user_id_for_sign_in_method()
    {
        $payload = new Payload($this->getPayloadData());

        $this->assertArrayNotHasKey('helixUserId', $payload->forSignUp());
    }

    /**
     * The payload data.
     *
     * @param array $overrides
     *
     * @return array
     */
    private function getPayloadData($overrides = [])
    {
        return array_merge([
            'helixUserId' => '690901',
            'catalogId' => 'A14E715F-CAF0-4749-B569-58059C9DD490',
            'accessToken' => 'E7DFA4373E531A7AA23B1955B94E6526BBA3C8BB854BCFE9248C590D3FA3D2E3',
            'clientUserId' => '3',
            'firstName' => 'Jason',
            'lastName' => 'Neal',
            'primaryLanguage' => 'en',
            'points' => '5000',
            'phoneNumber1' => '9726616031',
            'emailAddress' => 'it@brightspot.email',
            'shipAddress1' => '102 Decker Ct',
            'shipAddress2' => 'Suite 150',
            'shipCity' => 'Irving',
            'shipState' => 'TX',
            'shipPostalCode' => '75062',
            'shipCountry' => 'US',
        ], $overrides);
    }
}
