<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Views\Composers;

use Illuminate\View\View;

class IframeComposer
{
    /**
     * Bind data to the view.
     *
     * @param  View $view
     * @return void
     */
    public function compose(View $view)
    {
        $sessionKey = config('helix.sso.session.key', 'helix_login_url');
        $sessionValue = session()->get($sessionKey, null);

        $view->with('sessionExists', ! empty($sessionValue));

        $loginUrl = filter_var($sessionValue, FILTER_VALIDATE_URL) ? $sessionValue : false;
        $url = $loginUrl ? route('helix.redirect') : false;

        $view->with('url', $url);
    }
}
