<?php

namespace Ignite\Vendor\Helix\Laravel\Contracts;

use Ignite\Vendor\Helix\Laravel\Sso\Payload;
use Psr\Http\Message\ResponseInterface;

interface SsoClientInterface
{
    /**
     * Execute the sign in request.
     *
     * @param Payload $payload
     *
     * @return ResponseInterface
     */
    public function signIn(Payload $payload);

    /**
     * Execute the sign up request.
     *
     * @param Payload $payload
     *
     * @return ResponseInterface
     */
    public function signUp(Payload $payload);
}
