<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Views\Composers;

use Illuminate\View\View;

class IframeComposer
{
    /**
     * Bind data to the view.
     *
     * @param  View $view
     * @return void
     */
    public function compose(View $view)
    {
        $sessionKey = config('helix.sso.session.key', 'helix_login_url');
        $sessionValue = session()->get($sessionKey, null);

        $view->with('sessionExists', ! empty($sessionValue));
        $view->with('url', filter_var($sessionValue, FILTER_VALIDATE_URL) ? $sessionValue : false);
    }
}
