<?php

namespace Ignite\Vendor\Helix\Laravel\Resources;

use Ignite\Vendor\Helix\Laravel\Resources\Concerns\Statusable;
use Illuminate\Database\Eloquent\Model;

/**
 * Order
 *
 * @property int $user_id
 * @property string $access_token
 * @property string $order_number
 * @property string $first
 * @property string $last
 * @property string $ship_address_1
 * @property string $ship_address_2
 * @property string $ship_city
 * @property string $ship_state
 * @property string $ship_postcode
 * @property string $ship_country
 * @property string $ship_phone
 * @property int $qty
 * @property int $points
 * @property array $products
 */
class Order extends Model
{
    use Statusable;

    const STATUS_PROCESSING = 'processing';
    const STATUS_PROCESSED = 'processed';
    const STATUS_PURGING = 'purging';

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'helix_orders';

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'products' => 'array'
    ];
}
