<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers;

use Ignite\Vendor\Helix\Laravel\Events\WebhookResourceCreated;
use Ignite\Vendor\Helix\Laravel\Exceptions\InvalidAccessToken;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\CommonResponses;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\GuardAgainstInvalidToken;
use Ignite\Vendor\Helix\Laravel\Resources\Webhook;
use Ignite\Vendor\Helix\Laravel\Services\Token;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class WebhookController
{
    use GuardAgainstInvalidToken,
        CommonResponses;

    /**
     * Store the points check request.
     *
     * @param Request $request
     * @param Token $tokenService
     *
     * @return JsonResponse
     */
    public function __invoke(Request $request, Token $tokenService)
    {
        $userId = $request->json()->get('clientUserId');

        try {
            $this->guardAgainstInvalidAccessToken($request, $tokenService);

            $hash = md5(http_build_query($request->json()->all()));

            $webhook = Webhook::query()->updateOrCreate(compact('hash'), [
                'user_id' => $userId,
                'payload' => $request->json()->all(),
                'hash' => $hash
            ]);

            WebhookResourceCreated::dispatch($webhook);

            return $this->successResponse($request, 'Webhook processed');
        } catch (ModelNotFoundException $e) {
            return $this->notFoundResponse($request, "Not found - User ID " . ($userId) ? $userId : 'Missing');
        } catch (InvalidAccessToken $e) {
            return $this->forbiddenResponse($request, 'Forbidden - Access token is invalid');
        } catch (\Exception $e) {
            logger()->error($e->getMessage(), ['exception' => $e]);
            return $this->serviceUnavailableResponse($request);
        }
    }
}
