<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers;

use Ignite\Vendor\Helix\Laravel\Exceptions\InvalidAccessToken;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\CommonResponses;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\GuardAgainstInvalidToken;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\RetrievesPointsAttribute;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\RetrievesUserIdAttribute;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\RetrievesUserModel;
use Ignite\Vendor\Helix\Laravel\Services\Token;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class PointsController
{
    use RetrievesUserModel,
        RetrievesUserIdAttribute,
        RetrievesPointsAttribute,
        GuardAgainstInvalidToken,
        CommonResponses;

    /**
     * Store the points check request.
     *
     * @param Request $request
     * @param Token $tokenService
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function __invoke(Request $request, Token $tokenService)
    {
        $userId = $request->json()->get('clientUserId');

        try {
            $this->guardAgainstInvalidAccessToken($request, $tokenService);
            $user = $this->getUserModel()->query()
                ->where($this->getUserIdAttribute(), $userId)
                ->firstOrFail();

            return $this->successResponse($request, 'Result found', [
                'points' => $user->getAttribute($this->getPointsAttribute())
            ]);
        } catch (ModelNotFoundException $e) {
            return $this->notFoundResponse($request, "Not found - User ID " . ($userId) ? $userId : 'Missing');
        } catch (InvalidAccessToken $e) {
            return $this->forbiddenResponse($request, 'Forbidden - Access token is invalid');
        } catch (\Exception $e) {
            logger()->error($e->getMessage(), ['exception' => $e]);
            return $this->serviceUnavailableResponse($request);
        }
    }
}
