<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns;

use Ignite\Vendor\Helix\Laravel\Exceptions\InvalidAccessToken;
use Ignite\Vendor\Helix\Laravel\Services\Token;
use Illuminate\Http\Request;

trait GuardAgainstInvalidToken
{
    /**
     * Guard against an invalid access token by throwing an exception.
     *
     * @param Request $request
     * @param Token $tokenService
     *
     * @throws InvalidAccessToken
     */
    private function guardAgainstInvalidAccessToken(Request $request, Token $tokenService)
    {
        $accessToken = $request->json()->get('accessToken');

        $token = $tokenService->encrypt(config('helix.token.catalog'), $request->json()->get('clientUserId'));

        if ($accessToken !== $token) {
            throw new InvalidAccessToken($accessToken);
        }
    }
}
