<?php

return [
    'user' => [
        'model' => \App\User::class,
        'attributes' => [
            'id' => 'id',
            'points' => 'points'
        ]
    ],

    'token' => [
        // Secret catalog key
        'catalog' => env('HELIX_TOKEN_CATALOG'),

        // Cryptographically secure key
        'key' => env('HELIX_TOKEN_KEY', ''),

        // Encryption algorithm
        'cipher' => env('HELIX_TOKEN_CIPHER', 'AES-128-ECB'),
    ],

    /**
     * The Helix catalog ID is generated and sent to Helix.
     */
    'catalog' => env('HELIX_CATALOG_ID', ''),

    /**
     * The Helix username is provided by Helix.
     */
    'username' => env('HELIX_API_USERNAME', ''),

    /**
     * The Helix password is provided by Helix..
     */
    'password' => env('HELIX_API_PASSWORD', ''),

    /**
     * The Helix endpoint is provided by Helix.
     */
    'endpoint' => env('HELIX_API_ENDPOINT', ''),

    /**
     * The Helix adapter to use. By default we use the Guzzle Adapter since it already
     * implements the PSR-7 Http Standard Interfaces. If Guzzle was ever deprecated
     * we could swap the implementation out very easily from within this project.
     */
    'adapter' => 'guzzle',

    /**
     * The Helix decorator to use. By default we use the JSON decorator, JSON is the
     * easiest data format to use with the Helix API. However, we could swap out
     * the implementation easily if we ever needed to transform the response.
     */
    'decorator' => 'json',

    /**
     * The available adapters.
     */
    'adapters' => [
        'guzzle' => \Ignite\Vendor\Helix\Adapters\Guzzle::class
    ],

    /**
     * The available decorators.
     */
    'decorators' => [
        'json' => \Ignite\Vendor\Helix\Laravel\Decorators\Laravel::class
    ]
];
