# Helix Laravel Bridge

## Installation

```
composer require ignite/helix-api-laravel
```

## Configuration

### Publishing the configuration file

```
php artisan vendor:publish --force --provider=Ignite\Vendor\Helix\Laravel\HelixServiceProvider
```

### Making the routes work:

Open up your `VerifyCsrfToken` Middleware file located at `app/Http/Middleware/VerifyCsrfToken.php` and add the following exceptions:

```
    protected $except = [
        '/api/helix/points',
        '/api/helix/order'
    ];
```

### Write an Event Listener when a Order is created.

```
php artisan make:listener StoreOrderDetails --event=\\Ignite\\Vendor\\Helix\\Laravel\\Events\\OrderResourceCreated
```

The order resource contains the following information:

```
'order_number' => nullable string
'user_id' => unsigned big integer
'access_token' => string
'qty' => unsigned big integer
'points' => unsigned big integer containing the points to deduct
'first' => string
'last' => string
'ship_address_1' => string
'ship_address_2' => string
'ship_city' => string
'ship_state' => string
'ship_postcode' => string
'ship_country' => string
'ship_phone' => string
'product_id' => string
'product_name' => string
'status' => nullable string, default value: 'processing'
```

Once you 'process' the order resource, you should mark the `status` as `processed`.
