<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers;

use Ignite\Vendor\Helix\Laravel\Events\WebhookResourceCreated;
use Ignite\Vendor\Helix\Laravel\Exceptions\InvalidAccessToken;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\CommonResponses;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\GuardAgainstInvalidToken;
use Ignite\Vendor\Helix\Laravel\Resources\Webhook;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class WebhookController
{
    use GuardAgainstInvalidToken,
        CommonResponses;

    /**
     * Store the points check request.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function __invoke(Request $request)
    {
        try {
            $this->guardAgainstInvalidAccessToken($request);

            $hash = md5(implode('|', $request->json()->all()));

            $webhook = Webhook::query()->updateOrCreate(compact('hash'), [
                'user_id' => $request->json()->get('clientUserId'),
                'payload' => $request->json()->all(),
                'hash' => $hash
            ]);

            WebhookResourceCreated::dispatch($webhook);

            return response()->json([
                'code' => 200,
                'status' => 'success',
                'message' => 'Webhook processed',
            ], 200);
        } catch (ModelNotFoundException $e) {
            return $this->notFoundResponse($request);
        } catch (InvalidAccessToken $e) {
            return $this->forbiddenResponse($request);
        } catch (\Exception $e) {
            logger()->error($e->getMessage(), ['exception' => $e]);
            return $this->serviceUnavailableResponse($request);
        }
    }
}
