<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers;

use Ignite\Vendor\Helix\Laravel\Exceptions\InvalidAccessToken;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\CommonResponses;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\GuardAgainstInvalidToken;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\RetrievesPointsAttribute;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\RetrievesUserIdAttribute;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\RetrievesUserModel;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class PointsController
{
    use RetrievesUserModel,
        RetrievesUserIdAttribute,
        RetrievesPointsAttribute,
        GuardAgainstInvalidToken,
        CommonResponses;

    /**
     * Store the points check request.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function __invoke(Request $request)
    {
        try {
            $this->guardAgainstInvalidAccessToken($request);
            $user = $this->getUserModel()->query()
                ->where($this->getUserIdAttribute(), $request->json()->get('clientUserId'))
                ->firstOrFail();

            return response()->json([
                'code' => 200,
                'status' => 'success',
                'message' => 'Result found',
                'points' => $user->getAttribute($this->getPointsAttribute())
            ], 200);
        } catch (ModelNotFoundException $e) {
            return $this->notFoundResponse($request);
        } catch (InvalidAccessToken $e) {
            return $this->forbiddenResponse($request);
        } catch (\Exception $e) {
            logger()->error($e->getMessage(), ['exception' => $e]);
            return $this->serviceUnavailableResponse($request);
        }
    }
}
