<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers;

use Ignite\Vendor\Helix\Laravel\Exceptions\InvalidAccessToken;
use Ignite\Vendor\Helix\Laravel\Events\OrderResourceCreated;
use Ignite\Vendor\Helix\Laravel\Resources\Order;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\CommonResponses;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\GuardAgainstInvalidToken;
use Illuminate\Http\Request;

class OrderController
{
    use GuardAgainstInvalidToken,
        CommonResponses;

    /**
     * Create the order.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function __invoke(Request $request)
    {
        try {
            $this->guardAgainstInvalidAccessToken($request);

            $orderResource = Order::updateOrCreate(['order_number' => $request->json()->get('orderNumber')], [
                'user_id' => $request->json()->get('clientUserId'),
                'access_token' => $request->json()->get('accessToken'),
                'order_number' => $request->json()->get('orderNumber'),
                'first' => $request->json()->get('firstName'),
                'last' => $request->json()->get('lastName'),
                'ship_address_1' => $request->json()->get('shipAddress1'),
                'ship_address_2' => $request->json()->get('shipAddress2'),
                'ship_city' => $request->json()->get('shipCity'),
                'ship_state' => $request->json()->get('shipState'),
                'ship_postcode' => $request->json()->get('shipPostalCode'),
                'ship_country' => $request->json()->get('shipCountry'),
                'ship_phone' => $request->json()->get('phoneNumber'),
                'qty' => $request->json()->get('qty'),
                'points' => $request->json()->get('pointsToDeduct'),
                'products' => $request->json()->get('products', []),
            ]);

            OrderResourceCreated::dispatch($orderResource);

            return response()->json([
                'code' => 200,
                'status' => 'success',
                'message' => 'Order processing'
            ], 200);
        } catch (InvalidAccessToken $e) {
            return $this->forbiddenResponse($request);
        } catch (\Exception $e) {
            logger()->error($e->getMessage(), ['exception' => $e]);
            return $this->serviceUnavailableResponse($request);
        }
    }
}
