<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns;

use Illuminate\Http\Request;

trait CommonResponses
{
    /**
     * Return a 403 Forbidden Response.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    protected function forbiddenResponse(Request $request)
    {
        return response()->json([
            'code' => 403,
            'status' => 'error',
            'message' => 'Forbidden - Access token is invalid'
        ], 403);
    }

    /**
     * Return a 404 Not Found Response.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    protected function notFoundResponse(Request $request)
    {
        return response()->json([
            'code' => 404,
            'status' => 'error',
            'message' => 'User not found - ' . $request->json()->get('clientUserId') ?? 'No User ID'
        ], 404);
    }

    /**
     * Return a 503 Service Unavailable Response.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    protected function serviceUnavailableResponse(Request $request)
    {
        return response()->json([
            'code' => 503,
            'status' => 'error',
            'message' => 'Service Unavailable'
        ], 503, [
            'Retry-After' => (60 * 60 * 24) * 3 // 3 Days
        ]);
    }
}