<?php

namespace Ignite\Vendor\Helix\Laravel\Services;

class Token
{
    /**
     * Encrypt the user id to create the access token.
     *
     * @param int $userId
     *
     * @return string
     */
    public function encrypt($userId)
    {
        $catalogId = config('helix.catalog');
        $key = base64_decode(config('helix.token.key'));
        $algorithm = config('helix.token.algorithm');
        $token = openssl_encrypt($catalogId . $userId, $algorithm, $key, OPENSSL_RAW_DATA);
        $token = strtoupper(html_entity_decode(bin2hex($token), ENT_COMPAT, 'UTF-8'));

        return $token;
    }

    /**
     * Decrypt the access token and find the user id.
     *
     * @param string $token
     *
     * @return int
     */
    public function decrypt($token)
    {
        $catalogId = config('helix.catalog');
        $key = base64_decode(config('helix.token.key'));
        $algorithm = config('helix.token.algorithm');
        $source = openssl_decrypt(hex2bin($token), $algorithm, $key, OPENSSL_RAW_DATA);

        return str_replace($catalogId, '', $source);
    }
}
