<?php

namespace Ignite\Vendor\Helix\Laravel;

use Ignite\Vendor\Helix\Factory;
use Ignite\Vendor\Helix\HelixInterface;
use Illuminate\Support\ServiceProvider;

class HelixServiceProvider extends ServiceProvider
{
    /**
     * When Laravel is booting up, register configuration.
     */
    public function boot()
    {
        $this->loadRoutesFrom(__DIR__ . '/../routes/api.php');

        $this->loadMigrationsFrom(__DIR__.'/../migrations');

        $this->publishes([
            $this->helixConfigPath() => config_path('helix.php'),
        ]);
    }

    /**
     * When Laravel is registering service providers, register the ClientInterface
     * and provide an alias for use with a Facade.
     */
    public function register()
    {
        $this->mergeConfigFrom($this->helixConfigPath(), 'helix');

        $this->app->singleton(HelixInterface::class, function ($app) {
            $config = $app['config']->get('helix');

            $factory = new Factory($config['adapters'], $config['decorators']);

            return $factory->make(
                $config['username'],
                $config['password'],
                $config['endpoint'],
                $config['adapter'],
                $config['decorator']
            );
        });

        $this->app->alias(HelixInterface::class, 'helix');
    }

    /**
     * The path to the config file.
     *
     * @return bool|string
     */
    private function helixConfigPath()
    {
        return realpath(__DIR__ . '/../config/helix.php');
    }
}
