<?php

namespace Ignite\Vendor\Helix\Laravel\Events;

use Ignite\Vendor\Helix\Laravel\Resources\Order;
use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;

class OrderResourceCreated
{
    use Dispatchable, SerializesModels;

    /**
     * @var Order
     */
    protected $order;

    /**
     * Create a new event instance.
     *
     * @param Order $order
     */
    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    /**
     * The order resource model.
     *
     * @return Order
     */
    public function getOrder()
    {
        return $this->order;
    }
}
